-- Krufarm Software SQL Schema

CREATE TABLE IF NOT EXISTS users (
    user_id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    email VARCHAR(100) UNIQUE,
    role ENUM('admin', 'agent', 'verifier', 'viewer') DEFAULT 'agent',
    password_hash VARCHAR(255),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS land_owners (
    id INT AUTO_INCREMENT PRIMARY KEY,
    full_name VARCHAR(150),
    id_number VARCHAR(50),
    group_name VARCHAR(100),
    contact_info TEXT,
    consent_doc VARCHAR(255),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS plots (
    plot_id INT AUTO_INCREMENT PRIMARY KEY,
    owner_id INT,
    name VARCHAR(100),
    boundary_geojson LONGTEXT,
    land_use VARCHAR(100),
    deforestation_check_status ENUM('pending','passed','flagged') DEFAULT 'pending',
    area_ha DECIMAL(10,2),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS activities (
    id INT AUTO_INCREMENT PRIMARY KEY,
    plot_id INT,
    year INT,
    season VARCHAR(50),
    crop VARCHAR(100),
    fertilizer_type VARCHAR(100),
    tillage_method VARCHAR(100),
    cover_crop_used BOOLEAN,
    residue_management TEXT,
    irrigation_type VARCHAR(100),
    notes TEXT,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS documents (
    doc_id INT AUTO_INCREMENT PRIMARY KEY,
    linked_to ENUM('owner','plot','activity') NOT NULL,
    linked_id INT NOT NULL,
    file_name VARCHAR(255),
    file_type VARCHAR(50),
    purpose VARCHAR(100),
    uploaded_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS sync_logs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    entity_type VARCHAR(50),
    entity_id INT,
    sync_status ENUM('queued','synced','failed') DEFAULT 'queued',
    synced_at TIMESTAMP NULL,
    notes TEXT
);
