<?php
require_once __DIR__.'/../common/response.php';
require_once __DIR__.'/../common/validate.php';
require_once __DIR__.'/../../app/config/db.php';
$body = json_decode(file_get_contents('php://input'),true) ?? [];
try {
    require_fields($body,["owner_id","boundary_geojson","land_use","area_ha"]);
    $stmt = $pdo->prepare("INSERT INTO plots (owner_id,name,boundary_geojson,land_use,deforestation_check_status,area_ha,created_at)
                           VALUES (:owner,:name,:geo,:use,'pending',:area,NOW())");
    $stmt->execute([
        ":owner"=>$body["owner_id"],
        ":name"=>$body["name"] ?? "Field",
        ":geo"=>$body["boundary_geojson"],
        ":use"=>$body["land_use"],
        ":area"=>$body["area_ha"]
    ]);
    json_response(["message"=>"plot created"]);
} catch(Exception $e){
    json_response(["error"=>$e->getMessage()],400);
}
?>
